import { resizeImage } from '@shared/utils/resize-image';
import useSWRImmutable from 'swr/immutable';
import { getSiteLogo } from '@launch/api/DataApi';
import { useSiteProfile } from '@launch/hooks/useSiteProfile';

export const useSiteLogo = () => {
	const { siteProfile, loading: profileLoading } = useSiteProfile();

	const { data, error } = useSWRImmutable(
		!siteProfile?.logoObjectName || profileLoading
			? null
			: { key: 'site-logo', logoObjectName: siteProfile.logoObjectName },
		async ({ logoObjectName }) => {
			const rawLogoUrl = await getSiteLogo(logoObjectName);
			return await resizeImage(rawLogoUrl, {
				size: { width: 256, height: 256 },
				mimeType: 'image/webp',
			});
		},
	);

	return {
		logoUrl: data,
		error,
		loading: profileLoading || (!data && !error),
	};
};
